function test_suite = testFormat_equations %#ok<STOUT>
initTestSuite;

% function testNoInput
% f = @() polysym.format_equations;
% assertExceptionThrown(f,'MATLAB:inputArgUndefined');

function testOneInput %#ok<*DEFNU>
x = polysym('x');
f = @() format_equations(x);
if verLessThan('matlab','7.13.0')
    assertExceptionThrown(f,'MATLAB:inputArgUndefined')
else
    assertExceptionThrown(f,'MATLAB:minrhs')
end

function testMultipleEqnsPolysymLHS
x = polysym({'x','y'});
LHS = polysym({'u','v'});
out = format_equations(x,LHS);
assertEqual(out,{'x=u','y=v'})
